package de.renew.fa.service;

import java.io.InputStream;
import java.io.OutputStream;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.fa.util.FAHelper;


/**
 * Defines the Jflap format for a finite automata drawing (<code>FADrawing</code>).
 *
 * {@link de.renew.fa.util.FAHelper}
 * {@link de.renew.fa.service.FAFileParser}
 * @author Cabac
 *
 */
public class JflapFormat {
    /**
     * Check whether export is allowed using this format.
     * It might have been planned that export is not allowed for certain formats.
     * Instead, this is implemented via the ExportFormatHolder.
     *
     * @return true
     */
    //TODO: Check if this code is used
    public boolean canExport() {
        return true;
    }

    /**
     * Check whether import is allowed using this format.
     * It might have been planned that import is not allowed for certain formats.
     * Instead, this is implemented via the ImportFormatHolder.
     *
     * @return true
     */
    //TODO: Check if this code is used
    public boolean canImport() {
        return true;
    }

    /**
     * Parse a XFA and convert the parsed model into a <code>FADrawing</code>.
     *
     * @param stream - The input stream.
     * @param name - The name of the model.
     * @return An array of Drawings, in which is only one drawing.
     *        (To maintain compartability with <code>XMLFormat</code>.)
     * @throws Exception never thrown because it has already been caught at a lower method
     */
    //TODO: clean up exception handling, potentially unused function
    public Drawing[] parse(InputStream stream, String name) throws Exception {
        Drawing[] result = new Drawing[1];
        result[0] = FAHelper.convertModelToDrawing(new FAFileParser().parseXFA(stream, name));
        return result;
    }

    /**
     * Writes a FADrawing to an output stream in XFA format.
     *
     * @param stream the output stream
     * @param drawing the Drawing
     * @throws Exception never thrown because it has already been caught at a lower method
     */
    //TODO: clean up exception handling
    public void write(OutputStream stream, Drawing drawing) throws Exception {
        FAFileParser.writeToXFA(stream, drawing);
    }

    /**
     * Writes multiple FADrawing to an output stream in XFA format.
     *
     * @param stream the output stream
     * @param drawings the <code>FADrawing</code>
     * @throws Exception never thrown because it has already been caught at a lower method
     */
    //TODO: clean up exception handling
    public void write(OutputStream stream, Drawing[] drawings) throws Exception {
        //TODO fix this; only one drawing is written to the output stream, yet
        write(stream, drawings[0]);
    }
}