package de.renew.faformalism.util;

/**
 * This Enum represents all automaton types known to the FAAutomatonCompiler.
 * The individual values are selected by the user through the FASimulationSettingsInterface,
 * and determine how the {@link de.renew.faformalism} creates the {@link de.renew.faformalism.shadow.ShadowFAArc}s
 * and {@link de.renew.faformalism.shadow.ShadowFAState}s.
 */

public enum FAAutomatonModelEnum {
    /**
     * Currently identical to {@link FAAutomatonModelEnum#NFA}, as there is no differentiation between NFAs and DFAs.
     */
    DFA,
    /**
     * Words are interpreted and expected to be regular expressions.
     * Arcs may be epsilon-arcs (no inscription).
     */
    NFA,
    /**
     * Words are interpreted and expected to be omega-regular expressions.
     */
    BUECHI,
    /**
     * Currently not implemented.
     */
    PDA,
    /**
     * Currently not implemented.
     */
    TM,

    /**
     *  FANetCompiler. Allows uplinks/downlinks/Java calls on arcs, no semantically meaningful simulation of automaton.
     *  Not supported, used as flag to disable certain features for the FAAutomatonCompiler and FA plugin based on the chosen formalism.
     */
    NET
}
