package de.renew.faformalism.util;

/**
 * This static class manages the settings for the formalism, as set by the user through the FA plugin.
 * The settings determine which automaton model is simulated, if and which word is simulated, or if the
 * word is to be created through the simulation.
 */
public class SimulationSettingsManager {

    private static FAAutomatonModelEnum _currentModel = FAAutomatonModelEnum.NFA;

    private static boolean _simulateWordMode = true;

    private static boolean _manualSimulation = true;

    private SimulationSettingsManager() {}

    /**
     * Sets the automaton model.
     * When compiling the ShadowNet, the automaton will be interpreted as the given type.
     * @param model one of {@link FAAutomatonModelEnum}.
     */
    public static void setAutomatonModel(FAAutomatonModelEnum model) {
        _currentModel = model;
    }

    public static FAAutomatonModelEnum getAutomatonModel() {
        return _currentModel;
    }

    public static void setManualSimulation(boolean manualSimulation) {
        _manualSimulation = manualSimulation;
    }

    public static boolean getManualSimulation() {
        return _manualSimulation;
    }

    public static void setSimulateWordMode(boolean simulateWordMode) {
        _simulateWordMode = simulateWordMode;
    }

    public static boolean getSimulateWordMode() {
        return _simulateWordMode;
    }
}
