# Feature Structures (FS)

## User Guide

The Renew _FS_ plugin supports modelling processes and the creation of ontologies through the FSRenew mode.

### Features

- Comprises some net formalisms such as
  - Basic FS-nets (no compiler):
    Uses feature structures to inscribe places, arcs, and transitions. Place markings are multisets over feature structures. Bindings are determined through the unification of all feature structures used in the locality of a transition.
  - Java-nets with FS tokens (Java+FS Net Compiler):
    FS expressions are allowed in addition to Java expressions. There is no support for FS transition rules.
    - This compiler (Java+FS Net) is experimental and hence only available if de.renew.gui.fs.showExperimentalCompilers is set to be `true`. 
  - Elementary FS-nets (EFS Net Compiler):
    One-safe FS-nets without sets of feature structures. The formalism operates in either of two modes, namely value or reference semantics. Both come with formally defined interleaving, step, and process semantics. 
    - This compiler (EFS Net) is experimental and hence only available if de.renew.gui.fs.showExperimentalCompilers is set to be `true`.
  - Higher FS-nets (XFS Net Compiler):
    FS-nets extended with reference semantics, net instances, synchronous channels, and Java integration.
- Provides UML-like figures for information-oriented modeling

### Example Usage

1. Open a formalism structure net in the graphical editor.
2. Select the new Formalism via Simulation -> Formalism -> XFS Net Compiler.
3. Start the simulation. It will now run with XFS Net Compiler.

### Provided Commands

None.

### Installation

To install this plugin, you need to do the following things:
- Put the JAR file of this plugin into the `plugins` directory of your Renew installation.
- There should be a folder within the `libs` directory of this plugin. Put that folder into the `libs` directory of your Renew installation.

It will be automatically loaded at the startup of Renew - see below for more configuration options.

### Dependencies

This plugin depends on the following plugins and external libraries:

- `Formalism Gui`: Register new formalisms
- `Misc`: Provide synchronous channels for Java net stubs
- `Collections`: Provide higher data structures
- `log4j`: Logging framework

### Configuration

During the initialization of _FS_, the following properties are read from the `renew.properties` file in the Renew root directory.

| **NAME**                                    | **TYPE**  | **DESCRIPTION**                                                         | **DEFAULT** |
|:--------------------------------------------|:---------:|:------------------------------------------------------------------------|:------------|
| `de.renew.gui.fs.umlMode`                   | `boolean` | Specifies whether FS figures are rendered like UML classes and objects. | false       |
| `de.renew.gui.fs.showExperimentalCompilers` | `boolean` | Specifies whether experimental FSNet compilers are enabled.             | false       |

## Developer Guide

### Core Classes

- `FSPlugin`: Extends `Plugin Apapter` (which implements the `IPlugin` interface) to manage the startup and shutdown.
- `FSFigure`: Implements the `SemanticUpdateFigure` interface to display the main elements of this plugin.
- `SingleFSNetCompiler`: Compiles Java nets with feature structure expressions and concept preprocessing.
- `SingleXFSNetCompiler`: Extends `SingleFSNetCompiler` to define a compiler for higher FS-nets.

### How to Extend

_FS_ exposes the following interfaces:

- `de.renew.formalism.fs.FSNetParserConstants`
- `de.renew.formalism.efsnet.EFSNetConstants`
- `de.renew.formalism.fs.FSInscriptionParser`
- `de.renew.formalism.fsnet.XFSNetParserConstants`
- `de.renew.gui.fs.Drawable`
- `de.uni_hamburg.fs.Concept`
- `de.uni_hamburg.fs.JavaType`
- `de.uni_hamburg.fs.Node`
- `de.uni_hamburg.fs.ParsedType`
- `de.uni_hamburg.fs.Type`

### Additional Information

- _FS_ is usually named "Feature Structures"; to use it with Gradle, it is necessary to call it "FS".
- A dissertation concerning feature structures can be found here: https://vsis-www.informatik.uni-hamburg.de/getDoc.php/thesis/293/Diss_Wienberg.pdf (a VPN connection to the data network of the University is required for the download)