package de.renew.formalism.fs;

import java.util.Collection;
import java.util.Vector;

import de.renew.engine.searcher.Occurrence;
import de.renew.engine.searcher.Searcher;
import de.renew.expression.Expression;
import de.renew.expression.VariableMapper;
import de.renew.net.NetInstance;
import de.renew.net.Place;
import de.renew.net.Transition;
import de.renew.net.inscription.arc.Arc;


/**
 * Arc's in the context of FS
 */
public class FSArc extends Arc {

    /**
     * Creates an instance of FSArc with the place and transition it connects to, it's type,
     * and it's token and time expression.
     *
     * @param place The place that this arc connects to.
     * @param transition The transition that this arc connects to.
     * @param arcType the type of this arc
     * @param tokenExpr the token expression of this arc
     * @param timeExpr the time expression of this arc
     */
    public FSArc(
        Place place, Transition transition, Type arcType, Expression tokenExpr, Expression timeExpr)
    {
        super(place, transition, arcType, tokenExpr, timeExpr);
    }

    @Override
    public java.util.Collection<Occurrence> makeOccurrences(
        VariableMapper mapper, NetInstance netInstance, Searcher searcher)
    {
        Collection<Occurrence> coll = new Vector<Occurrence>();
        coll.add(new FSArcOccurrence(this, mapper, netInstance));
        return coll;
    }
}