package de.renew.formalism.fs;

import de.renew.expression.VariableMapper;
import de.renew.net.NetInstance;
import de.renew.net.SimulatablePlaceInstance;
import de.renew.net.inscription.arc.Arc;
import de.renew.net.inscription.arc.ArcOccurrence;
import de.renew.net.inscription.arc.InhibitorArcBinder;
import de.renew.unify.Variable;


/**
 * ArcOccurrence's used in the context of FS.
 */
public class FSArcOccurrence extends ArcOccurrence {

    /**
     * Creates an instance of FSArcOccurrence with the associated arc, a mapper to map the local variables
     * to their respective values and the netInstance the FSArcOccurrence is in.
     *
     * @param arc the arc associated with this occurrence
     * @param mapper the mapper for this occurrence's variables
     * @param netInstance the net instance that this occurrence is in
     */
    public FSArcOccurrence(Arc arc, VariableMapper mapper, NetInstance netInstance) {
        super(arc, mapper, netInstance);
    }

    @Override
    protected InhibitorArcBinder getInhibitorArcBinder(
        Variable tokenVar, SimulatablePlaceInstance placeInstance)
    {
        return new FSInhibitorArcBinder(tokenVar, placeInstance);
    }
}