package de.renew.formalism.fs;

import java.util.Iterator;

import de.uni_hamburg.fs.FeatureStructure;

import de.renew.net.SimulatablePlaceInstance;
import de.renew.net.TokenReserver;
import de.renew.net.inscription.arc.InhibitorArcBinder;
import de.renew.unify.Variable;


/**
 * InhibitorArcBinder's in the context of FS.
 */
public class FSInhibitorArcBinder extends InhibitorArcBinder {

    /**
     * Creates an instance of FSInhibitorArcBinder with a variable to bound and a
     * connected placeInstance.
     *
     * @param variable the {@code Variable} that will be bound
     * @param placeInstance the placeInstance that is connected to this inhibitor arc binder
     */
    protected FSInhibitorArcBinder(Variable variable, SimulatablePlaceInstance placeInstance) {
        super(variable, placeInstance);
    }

    @Override
    protected boolean possible(TokenReserver reserver, Object token) {
        if (token instanceof FeatureStructure) {
            FeatureStructure fs = (FeatureStructure) token;
            Iterator<Object> tokens = getPlaceInstance().getDistinctTestableTokens().iterator();
            while (tokens.hasNext()) {
                Object tok = tokens.next();
                if (tok instanceof FeatureStructure && fs.canUnify((FeatureStructure) tok)) {
                    return false;
                }
            }
            return true;
        }
        return super.possible(reserver, token);
    }
}