package de.renew.formalism.fs;

import de.renew.shadowcompiler.ShadowPreprocessor;


/**
 * Compiles Java nets with feature structure expressions, but
 * <em>without</em> concept preprocessing.  Instances of this class are
 * created by the factory {@link FSNetWithoutConceptsCompiler}.
 *
 * @author Michael Duvigneau
 **/
public class SingleFSNetWithoutConceptsCompiler extends SingleFSNetCompiler {

    /**
     * Default constructor for SingleFSNetWithoutConceptsCompiler.
     */
    public SingleFSNetWithoutConceptsCompiler() {}

    /**
     * The <code>SingleFSNetWithoutConceptsCompiler</code> needs no
     * preprocessor because it does not change the concept system.
     *
     * @return an empty array.
     **/
    @Override
    public final ShadowPreprocessor[] getRequiredPreprocessors() {
        return new ShadowPreprocessor[0];
    }
}