package de.renew.formalism.fsnet;

import java.awt.AWTEvent;

import de.renew.call.SynchronisationRequest;
import de.renew.net.NetInstance;
import de.renew.unify.Tuple;
import de.renew.unify.Variable;


/**
 * Class needed for an BDI example using FSNets by Frank Wienberg (in his dissertation models directory).
 */
public abstract class EventListenerFSNet {
    private NetInstance _myInstance = null;
    Object _myComponent = null;

    public EventListenerFSNet() {}

    public EventListenerFSNet(NetInstance instance) {
        _myInstance = instance;
    }

    public void eventOccured(final AWTEvent event) {
        new Thread() {
            @Override
            public void run() {
                Variable var = new Variable();
                SynchronisationRequest.synchronize(
                    _myInstance, "s", new Tuple(new Object[] { event, var, var }, null));
            }
        }.start();
    }

    public NetInstance getListener() {
        return _myInstance;
    }

    public void setListener(NetInstance instance) {
        _myInstance = instance;
    }

    public Object getComponent() {
        return _myComponent;
    }
}