package de.renew.formalism.fsnet;

import java.awt.TextComponent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

import de.renew.net.NetInstance;


/**
 * Class needed for an BDI example using FSNets by Frank Wienberg (in his dissertation models directory).
 */
public class TextListenerFSNet extends EventListenerFSNet implements TextListener {
    public TextListenerFSNet() {}

    public TextListenerFSNet(NetInstance instance) {
        super(instance);
    }

    public TextListenerFSNet(NetInstance instance, TextComponent component) {
        this(instance);
        setComponent(component);
    }

    @Override
    public void textValueChanged(TextEvent event) {
        eventOccured(event);
    }

    public void setComponent(Object comp) {
        if (_myComponent instanceof TextComponent) {
            ((TextComponent) _myComponent).removeTextListener(this);
        }
        _myComponent = comp;
        if (_myComponent instanceof TextComponent) {
            ((TextComponent) _myComponent).addTextListener(this);
        }
    }
}