package de.renew.gui.fs;

import java.awt.Graphics;

class BracketSubFigure implements Drawable {
    int[] _leftBracketX;
    int[] _leftBracketY;
    int[] _rightBracketX;
    int[] _rightBracketY;

    BracketSubFigure(int x, int y, int width, int height, int d, boolean angle) {
        int xr = x + width - 1;
        int yu = y + height - 1;
        if (angle) {
            int ym = y + height / 2;
            _leftBracketX = new int[] { x + d, x, x + d };
            _leftBracketY = new int[] { y, ym, yu };
            _rightBracketX = new int[] { xr - d, xr, xr - d };
            _rightBracketY = new int[] { y, ym, yu };
        } else {
            _leftBracketX = new int[] { x + d, x, x, x + d };
            _leftBracketY = new int[] { y, y, yu, yu };
            _rightBracketX = new int[] { xr - d, xr, xr, xr - d };
            _rightBracketY = new int[] { y, y, yu, yu };
        }
    }

    @Override
    public void draw(Graphics g) {
        g.drawPolyline(_leftBracketX, _leftBracketY, _leftBracketX.length);
        g.drawPolyline(_rightBracketX, _rightBracketY, _rightBracketX.length);
    }
}
