/*
 * @(#)SetEFSNetSemanticsCommand.java 5.1
 *
 */

package de.renew.gui.fs;

import CH.ifa.draw.util.Command;
import de.renew.draw.ui.api.EditorApi;
import de.renew.draw.ui.ontology.DrawingEditor;
import de.renew.formalism.efsnet.SingleEFSNetCompiler;


/**
 * A command to switch the semantics in EFSNets between
 * "Value" and "Reference".
 */
public class SetEFSNetSemanticsCommand extends Command {
    private boolean _fValueSem;

    /**
     * Constructs a net semantic switch command.
     * @param name the command name
     * @param valueSem whether value semantics are requested.
     */
    public SetEFSNetSemanticsCommand(String name, boolean valueSem) {
        super(name);
        _fValueSem = valueSem;
    }

    /**
     * Get the current {@link DrawingEditor}.
     *
     * @return DrawingEditor
     */
    protected DrawingEditor getEditor() {
        return EditorApi.getCurrentEditor();
    }

    @Override
    public void execute() {
        SingleEFSNetCompiler._valueSem = _fValueSem;
    }
}