package de.uni_hamburg.fs;

import java.util.Enumeration;


/**
 * Representation of any node
 */
public abstract class AbstractNode implements Node {

    /**
     * Type of the node.
     */
    protected Type _nodetype;

    /**
     * Creates a node with given Type.
     *
     * @param nodetype type of node to be created
     */
    protected AbstractNode(Type nodetype) {
        this._nodetype = nodetype;
    }

    /**
     * Creates a node with the Type 'ANY'
     */
    protected AbstractNode() {
        this(Type.ANY);
    }

    /**
     * Creates a node of the type given by its string representation
     *
     * @param nodetype string representation of the nodetype
     * @throws UnificationFailure if unifictaion fails
     */
    protected AbstractNode(String nodetype) throws UnificationFailure {
        this(ConjunctiveType.getType(nodetype));
    }

    @Override
    public Type getType() {
        return _nodetype;
    }

    @Override
    public Node delta(Path path) throws NoSuchFeatureException {
        Enumeration<?> featenumeration = path.features();
        Node curr = this;
        while (featenumeration.hasMoreElements()) {
            curr = curr.delta((Name) featenumeration.nextElement());
        }
        return curr;
    }
}