package de.uni_hamburg.fs;

import collections.CollectionEnumeration;


/**
 * An enumeration of Concept objects that provides specialized access methods
 * while preserving compatibility with the CollectionEnumeration interface.
 */
public class ConceptEnumeration implements CollectionEnumeration {
    /**
     * The delegate collection enumeration that handles the iteration functionality.
     * This field stores the underlying enumeration of concepts, either created from
     * a ConceptSet or wrapped from an existing CollectionEnumeration instance.
     */
    private CollectionEnumeration _enumeration;

    /**
     * Constructs a ConceptEnumeration from a ConceptSet.
     *
     * @param concepts the ConceptSet to enumerate
     */
    public ConceptEnumeration(ConceptSet concepts) {
        _enumeration = concepts.elements();
    }

    /**
     * Constructs a ConceptEnumeration from an existing CollectionEnumeration.
     *
     * @param enumeration the source enumeration to wrap
     */
    public ConceptEnumeration(CollectionEnumeration enumeration) {
        this._enumeration = enumeration;
    }

    @Override
    public boolean hasMoreElements() {
        return _enumeration.hasMoreElements();
    }

    @Override
    public Object nextElement() {
        return _enumeration.nextElement();
    }

    /**
     * Returns the next element in the enumeration as a Concept.
     *
     * @return the next element as a Concept
     */
    public Concept nextConcept() {
        return (Concept) _enumeration.nextElement();
    }

    @Override
    public int numberOfRemainingElements() {
        return _enumeration.numberOfRemainingElements();
    }

    @Override
    public boolean corrupted() {
        return _enumeration.corrupted();
    }
}