package de.uni_hamburg.fs;

class UnifyItem extends ToDoItem {
    Node _otherNode;

    UnifyItem(Node node, Node otherNode) {
        super(node);
        this._otherNode = otherNode;
    }

    @Override
    void doIt(EquivRelation er) throws UnificationFailure {
        _node = er.getUnificator(_node);
        _otherNode = er.getUnificator(_otherNode);
        er.unifyOne(_node, _otherNode);
    }

    @Override
    public String toString() {
        return "Unifying node of type " + _node.getType() + "("
            + _node.getType().getClass().getName() + ") with node of type " + _otherNode.getType()
            + "(" + _otherNode.getType().getClass().getName() + ").";
    }
}
