package de.uni_hamburg.fs;

import org.junit.jupiter.api.Test;

import collections.CollectionEnumeration;

import static org.assertj.core.api.Assertions.assertThat;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

class ConceptEnumerationTest {

    @Test
    void testConstructorWithConceptSet() {
        // given
        ConceptSet mockConceptSet = mock(ConceptSet.class);
        ConceptEnumeration mockInnerEnumeration = mock(ConceptEnumeration.class);
        when(mockConceptSet.elements()).thenReturn(mockInnerEnumeration);

        // when
        ConceptEnumeration enumeration = new ConceptEnumeration(mockConceptSet);

        // then
        assertThat(enumeration).isNotNull();
    }

    @Test
    void testConstructorWithCollectionEnumeration() {
        // given
        CollectionEnumeration mockEnumeration = mock(CollectionEnumeration.class);

        // when
        ConceptEnumeration enumeration = new ConceptEnumeration(mockEnumeration);

        // then
        assertThat(enumeration).isNotNull();
    }

    @Test
    void testHasMoreElements() {
        // given
        CollectionEnumeration mockEnumeration = mock(CollectionEnumeration.class);
        when(mockEnumeration.hasMoreElements()).thenReturn(true, false);
        ConceptEnumeration enumeration = new ConceptEnumeration(mockEnumeration);

        // when & then
        assertThat(enumeration.hasMoreElements()).isTrue();
    }

    @Test
    void testNextElement() {
        // given
        CollectionEnumeration mockEnumeration = mock(CollectionEnumeration.class);
        Concept mockConcept = mock(Concept.class);
        when(mockEnumeration.nextElement()).thenReturn(mockConcept);
        ConceptEnumeration enumeration = new ConceptEnumeration(mockEnumeration);

        // when
        Object result = enumeration.nextElement();

        // then
        assertThat(result).isSameAs(mockConcept);
    }

    @Test
    void testNextConcept() {
        // given
        CollectionEnumeration mockEnumeration = mock(CollectionEnumeration.class);
        Concept mockConcept = mock(Concept.class);
        when(mockEnumeration.nextElement()).thenReturn(mockConcept);
        ConceptEnumeration enumeration = new ConceptEnumeration(mockEnumeration);

        // when
        Concept result = enumeration.nextConcept();

        // then
        assertThat(result).isSameAs(mockConcept);
    }

    @Test
    void testNumberOfRemainingElements() {
        // given
        CollectionEnumeration mockEnumeration = mock(CollectionEnumeration.class);
        when(mockEnumeration.numberOfRemainingElements()).thenReturn(5);
        ConceptEnumeration enumeration = new ConceptEnumeration(mockEnumeration);

        // when
        int result = enumeration.numberOfRemainingElements();

        // then
        assertThat(result).isEqualTo(5);
    }

    @Test
    void testCorrupted() {
        // given
        CollectionEnumeration mockEnumeration = mock(CollectionEnumeration.class);
        when(mockEnumeration.corrupted()).thenReturn(true);
        ConceptEnumeration enumeration = new ConceptEnumeration(mockEnumeration);

        // when
        boolean result = enumeration.corrupted();

        // then
        assertThat(result).isTrue();
    }
}