package de.renew.formalism.java;

/**
 * Abstract class for creating suggestion objects.
 */
public abstract class Suggestion implements Comparable<Suggestion> {

    /**
     * The name of the suggestion.
     */
    protected String _name;

    /**
     * The type name of the suggestion.
     */
    protected String _typeName;

    /**
     * Initializes the suggestion with name and type.
     * @param name the name of the suggestion
     * @param typeName the type name of the suggestion
     */
    protected Suggestion(String name, String typeName) {
        this._name = name;
        this._typeName = typeName;
    }

    @Override
    public abstract String toString();

    /**
     * Gets the name of the suggestion.
     * @return the name of the suggestion
     */
    public String getName() {
        return _name;
    }

    /**
     * Gets the type name of the suggestion.
     * @return the type name of the suggestion
     */
    public String getTypeName() {
        return _typeName;
    }

    @Override
    public int compareTo(Suggestion suggestion) {
        int compareNames = getName().compareTo(suggestion.getName());

        if (compareNames == 0) {
            return suggestion.getName().length() - getName().length();
        } else {
            return compareNames;
        }
    }
}