package de.renew.formalism.java;

/**
 * Represents a timed expression used in arc inscriptions.
 */
public class TimedExpression implements ArcInscription {
    private TypedExpression _expr;
    private TypedExpression _timeExpr;

    /**
     * Initializes the timed expression with its expression and time expression.
     * @param expr the expression
     * @param timeExpr the time expression
     */
    public TimedExpression(TypedExpression expr, TypedExpression timeExpr) {
        this._expr = expr;
        this._timeExpr = timeExpr;
    }

    @Override
    public TypedExpression getExpression() {
        return _expr;
    }

    @Override
    public TypedExpression getTime() {
        return _timeExpr;
    }

    @Override
    public boolean isTimed() {
        return _timeExpr != null;
    }

    @Override
    public String toString() {
        final int sbSize = 1000;
        final String variableSeparator = ", ";
        final StringBuffer sb = new StringBuffer(sbSize);
        sb.append("TimedExpr(");
        sb.append("time: ").append(_timeExpr);
        sb.append(variableSeparator);
        sb.append(_expr);
        sb.append(")");
        return sb.toString();
    }
}