package de.renew.formalism;

import org.junit.jupiter.api.Test;

import de.renew.formalism.java.ChannelInscription;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertTrue;

public class ChannelInscriptionTest {

    @Test
    public void testConstructor() {
        //given
        String name = "test";
        int arity = 1;
        boolean isUplink = true;
        int expectedHash = name.hashCode() + arity * 135 + (isUplink ? 137 : 0);

        //when
        ChannelInscription testee = new ChannelInscription(true, "test", 1);

        //then
        assertEquals(expectedHash, testee.hashCode());
        assertEquals(name, testee._name);
        assertEquals(arity, testee._arity);
        assertEquals(isUplink, testee._isUplink);
    }

    @Test
    public void testEqualsSameValues() {
        //given
        ChannelInscription left = new ChannelInscription(true, "test", 1);
        ChannelInscription right = new ChannelInscription(true, "test", 1);

        //when
        boolean result = left.equals(right);

        //then
        assertTrue(result);
    }

    @Test
    public void testEqualsWrongType() {
        //given
        ChannelInscription testee = new ChannelInscription(true, "Test", 1);
        Object o = new Object();

        //when
        boolean result = testee.equals(o);

        //then
        assertFalse(result);
    }

    @Test
    public void testEqualsDifferentValues() {
        //given
        ChannelInscription left = new ChannelInscription(true, "Test", 1);
        ChannelInscription right = new ChannelInscription(true, "Test", 2);

        //when
        boolean result = left.equals(right);

        //then
        assertFalse(result);
    }
}
