package de.renew.formalism;

import org.junit.jupiter.api.Test;

import de.renew.expression.LocalVariable;
import de.renew.formalism.bool.LocalVariableSet;

import static org.junit.jupiter.api.Assertions.assertEquals;

public class LocalVariableSetTest {

    @Test
    public void testCreate() {
        //given
        LocalVariableSet testee = new LocalVariableSet();
        String testString = "test";
        LocalVariable testVariable = new LocalVariable(testString);

        //when
        LocalVariable resultVariable = testee.create(testString);

        //then
        assertEquals(testVariable, resultVariable);
    }

    @Test
    public void testCreateSameValue() {
        //given
        LocalVariableSet testee = new LocalVariableSet();
        String testString = "test";
        LocalVariable testVariable1 = new LocalVariable(testString + "'");
        testee.create(testString);

        //when
        LocalVariable resultVariable = testee.create(testString);

        //then
        assertEquals(testVariable1, resultVariable);


    }
}
