package de.renew.formalism;

import org.junit.jupiter.api.Test;

import de.renew.formalism.java.TimedExpression;
import de.renew.formalism.java.TypedExpression;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertNotNull;
import static org.junit.jupiter.api.Assertions.assertTrue;
import static org.mockito.Mockito.mock;

public class TimedExpressionTest {

    @Test
    public void testTimedExpression() {
        //when
        final TimedExpression testee =
            new TimedExpression(mock(TypedExpression.class), mock(TypedExpression.class));
        //then
        assertNotNull(testee);
    }

    @Test
    public void testGetExpression() {
        //given
        final TypedExpression e = mock(TypedExpression.class);
        final TypedExpression te = mock(TypedExpression.class);
        final TimedExpression testee = new TimedExpression(e, te);
        //when
        final TypedExpression result = testee.getExpression();
        //then
        assertEquals(result, e);
    }

    @Test
    public void testGetTime() {
        //given
        final TypedExpression e = mock(TypedExpression.class);
        final TypedExpression te = mock(TypedExpression.class);
        final TimedExpression testee = new TimedExpression(e, te);
        //when
        final TypedExpression result = testee.getTime();
        //then
        assertEquals(result, te);
    }

    @Test
    public void testIsTimed() {
        //given
        final TypedExpression e = mock(TypedExpression.class);
        final TypedExpression te = mock(TypedExpression.class);
        final TimedExpression testee1 = new TimedExpression(e, te);
        final TimedExpression testee2 = new TimedExpression(e, null);
        //when
        final boolean result1 = testee1.isTimed();
        final boolean result2 = testee2.isTimed();
        //then
        assertTrue(result1);
        assertFalse(result2);
    }

    @Test
    public void testToString() {
        //given
        final TypedExpression e = mock(TypedExpression.class);
        final TypedExpression te = mock(TypedExpression.class);
        final TimedExpression testee = new TimedExpression(e, te);
        //when
        final String result = testee.toString();
        //then
        assertEquals("TimedExpr(time: " + te + ", " + e + ")", result);
    }
}