package de.renew.formalism.function;

import org.junit.jupiter.api.Test;

import de.renew.net.inscription.arc.Arc;
import de.renew.unify.Impossible;
import de.renew.unify.Tuple;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertThrows;
import static org.mockito.Mockito.mock;

public class DynamicFieldWriteFunctionTest {

    @Test
    public void testFunctionException() throws Exception {
        //given
        Arc arcObject = mock(Arc.class);
        Object[] testValues = { arcObject, null };
        Tuple testTuple = new Tuple(testValues, null);
        DynamicFieldWriteFunction testDynamicFieldWriteFunction =
            new DynamicFieldWriteFunction("Type.OUT");

        String exceptionMessage =
            "Exception occured during method call: java.lang.NoSuchFieldException: Type.OUT";

        //when
        Exception thrown = assertThrows(Impossible.class, () -> {
            testDynamicFieldWriteFunction.function(testTuple);
        });
        //then
        assertEquals(exceptionMessage, thrown.getMessage());
    }

    @Test
    public void testFunction() throws Impossible {
        //given
        TestFieldClass testObject = new TestFieldClass();
        Object[] testValues = { testObject, null };
        Tuple testTuple = new Tuple(testValues, null);
        DynamicFieldWriteFunction testDynamicFieldWriteFunction =
            new DynamicFieldWriteFunction("_testLogger");

        //when
        Object output = testDynamicFieldWriteFunction.function(testTuple);

        //then
        assertEquals(TestFieldClass._testLogger, output);
    }
}
