package de.renew.formalism.java;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertTrue;

public class SuggestionTest {

    @Test
    public void testConstructor() {
        // given
        Suggestion suggestion = makeSuggestion("Aladdin", "character");

        // when
        String name = suggestion.getName();
        String typeName = suggestion.getTypeName();

        // then
        assertEquals("Aladdin", name);
        assertEquals("character", typeName);
    }

    @Test
    public void testCompareTo() {

        // given
        Suggestion sug1 = makeSuggestion("Aladdin", "character");

        Suggestion sug2 = makeSuggestion("Mulan", "character");

        // when
        int comparison = sug1.compareTo(sug2);
        int comparisonEqual1 = sug1.compareTo(sug1);
        int comparisonEqual2 = sug2.compareTo(sug2);
        int comparisonBackwards = sug2.compareTo(sug1);

        // then
        assertTrue(comparison < 0);
        assertTrue(0 < comparisonBackwards);
        assertEquals(0, comparisonEqual1);
        assertEquals(0, comparisonEqual2);
    }

    private Suggestion makeSuggestion(String name, String typeName) {
        return new Suggestion(name, typeName) {
            @Override
            public String toString() {
                return "not implemented";
            }
        };
    }
}
