package de.renew.gui;

import java.util.EventListener;

/**
 * Listener interested in if a CPNFigure is added or removed from a CPNDrawing
 */
public interface CPNFigureListener extends EventListener {

    /**
     * Sent when a CPNFigure was added
     *
     * @param e the CPNFigureEvent that is registered
     */
    void cpnFigureAdded(CPNFigureEvent e);

    /**
     * Sent when a CPNFigure was removed
     *
     * @param e the CPNFigureEvent that is registered
     */
    void cpnFigureRemoved(CPNFigureEvent e);
}
