package de.renew.gui;

import CH.ifa.draw.util.Command;


/**
 * This command implements the clearing of all breakpoints in the running simulation.
 *
 * @author Michael Duvigneau
 */
public class ClearAllBreakpointsCommand extends Command {
    private final BreakpointManager manager;
    private final CPNSimulation simulation;

    /**
     * Creates a new instance of the command.
     *
     * @param name the name of the command
     * @param manager the breakpoint manager storing breakpoint information
     * @param simulation the simulation the {@code manager} is attached to
     */
    public ClearAllBreakpointsCommand(
        String name, BreakpointManager manager, CPNSimulation simulation)
    {
        super(name);
        this.manager = manager;
        this.simulation = simulation;
    }

    /**
     * Indicates whether this command is executable.
     *
     * @return {@code true} if a simulation is running, {@code false} otherwise.
     **/
    @Override
    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        return simulation.isSimulationActive();
    }

    @Override
    public void execute() {
        manager.deleteAllBreakpoints();
    }
}
