/*
 * @(#)InhibitorConnection.java 5.1
 *
 */
package de.renew.gui;

import de.renew.simulatorontology.shadow.ShadowArc;


public class DoubleArcConnection extends ArcConnection {
    public static final DoubleArcConnection DoubleArc = new DoubleArcConnection();

    public DoubleArcConnection() {
        fArrowTipClass = DoubleArrowTip.class;
        setStartDecoration(null);
        setEndDecoration();
    }

    @Override
    protected void setStartDecoration() {
        setStartDecoration(new DoubleArrowTip());
    }

    @Override
    protected void setEndDecoration() {
        setEndDecoration(new DoubleArrowTip());
    }

    @Override
    public int getArcType() {
        return ShadowArc.DOUBLE_ORDINARY;
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (name.equals("ArrowMode")) {
            Integer intObj = (Integer) value;
            if (intObj != null) {
                int decoration = intObj;

                switch (decoration) {
                    case ARROW_TIP_START:
                        setStartDecoration(new DoubleArrowTip());
                        setEndDecoration(null);
                        changed();
                        break;
                    case ARROW_TIP_END:
                        setStartDecoration(null);
                        setEndDecoration(new DoubleArrowTip());
                        changed();
                        break;
                }
            }
        } else {
            super.setAttribute(name, value);
        }
    }
}