package de.renew.gui;


/**
 * Listener interested in if a CPNDrawing is opened or closed.
 */
public interface DrawingListener {

    /**
     * Sent when a CPNDrawing is created or loaded.
     *
     * @param e the DrawingEvent that is registered
     */
    void drawingOpened(DrawingEvent e);

    /**
     * Sent when a CPNDrawing is closed
     *
     * @param e the DrawingEvent that is registered
     */
    void drawingClosed(DrawingEvent e);
}
