package de.renew.gui;

import java.util.EventObject;

/**
 * EditorCreated event passed to EditorCreatedListeners.
 */
public class EditorCreatedEvent extends EventObject {
    final CPNDrawingEditor _editor;

    /**
     * Constructs an event for the given source editor.
     * @param source the object on which the Event initially occurred.
     * @param editor the editor that is created
     */
    public EditorCreatedEvent(Object source, CPNDrawingEditor editor) {
        super(source);
        _editor = editor;
    }

    /**
     * Gets the editor of the source.
     * @return returns the editor
     */
    public CPNDrawingEditor getEditor() {
        return _editor;
    }

    @Override
    public String toString() {
        return "EditorCreatedEvent{source=" + source + ", _editor=" + _editor + '}';
    }
}
