/*
 * Created on 28.01.2004
 *
 */
package de.renew.gui.menu;

import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JMenuItem;

import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.figures.ArrowTip;
import CH.ifa.draw.util.CommandMenu;
import CH.ifa.draw.util.CommandMenuItem;
import de.renew.draw.ui.api.CommandApi;
import de.renew.gui.AssocArrowTip;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.CompositionArrowTip;
import de.renew.gui.DoubleArrowTip;
import de.renew.gui.IsaArrowTip;


/**
 * This class creates the menu extensions for the Attributes menu.
 * <ul>
 * <li><em>Arrow Shape</em> lets you choose double tipped arrows </li>
 * <li><em>Text Type</em> lets you change the type of a text field (label, inscription, name)</li>
 * </ul>
 *
 * @author J&ouml;rn Schumacher
 */
public class AttributesMenuExtender {
    public Collection<JMenuItem> createMenus() {
        Collection<JMenuItem> result = new ArrayList<>();
        result.add(MenuManager.createSeparator("de.renew.gui.align.sep"));

        /*
         * TODO: JSC: Move to CH
         */
        CommandMenu arrowTipMenu = DrawApplication.createCommandMenu("Arrow Shape");
        arrowTipMenu.add(
            new CommandMenuItem(
                CommandApi
                    .createChangeAttributeCommand("normal", "ArrowTip", ArrowTip.class.getName())));
        arrowTipMenu.add(
            new CommandMenuItem(
                CommandApi.createChangeAttributeCommand(
                    "double", "ArrowTip", DoubleArrowTip.class.getName())));
        arrowTipMenu.add(
            new CommandMenuItem(
                CommandApi.createChangeAttributeCommand(
                    "lines", "ArrowTip", AssocArrowTip.class.getName())));
        arrowTipMenu.add(
            new CommandMenuItem(
                CommandApi.createChangeAttributeCommand(
                    "triangle", "ArrowTip", IsaArrowTip.class.getName())));
        arrowTipMenu.add(
            new CommandMenuItem(
                CommandApi.createChangeAttributeCommand(
                    "diamond", "ArrowTip", CompositionArrowTip.class.getName())));

        result.add(arrowTipMenu);
        CommandMenu textTypeMenu = DrawApplication.createCommandMenu("Text Type");

        textTypeMenu.add(
            new CommandMenuItem(
                CommandApi.createChangeAttributeCommand("Label", "TextType", CPNTextFigure.LABEL)));
        textTypeMenu.add(
            new CommandMenuItem(
                CommandApi.createChangeAttributeCommand(
                    "Inscription", "TextType", CPNTextFigure.INSCRIPTION)));
        textTypeMenu.add(
            new CommandMenuItem(
                CommandApi.createChangeAttributeCommand("Name", "TextType", CPNTextFigure.NAME)));
        result.add(textTypeMenu);
        return result;
    }
}