package de.renew.gui.nin;

import java.awt.*;
import javax.swing.*;

/**
 * Renderer for cells of a {@link JList}.
 * With it, each cell is marked as selected by a checkbox,
 * instead of its background being blue.
 *
 * @author Lukas Voß
 */
public class CheckboxListCellRenderer<E> extends JCheckBox implements ListCellRenderer<E> {

    public Component getListCellRendererComponent(
        JList list, Object value, int index, boolean isSelected, boolean cellHasFocus)
    {

        setComponentOrientation(list.getComponentOrientation());
        setFont(list.getFont());
        setBackground(list.getBackground());
        setForeground(list.getForeground());
        setSelected(isSelected);
        setEnabled(list.isEnabled());

        setText(value == null ? "" : value.toString());

        return this;
    }
}