package de.renew.gui.pnml.converter;

import org.w3c.dom.Element;

import CH.ifa.draw.figures.TextFigure;
import de.renew.draw.storables.ontology.Figure;
import de.renew.gui.CPNTextFigure;
import de.renew.io.exportFormats.PNMLExportFormat;


/**
 * Used to convert between the contents of a {@link de.renew.gui.CPNDrawing}
 * (in the form of {@link Figure} objects)
 * and the contents of an {@link Element} representing the same net
 * in a PNML file.
 * <p>
 * See also {@link Converter}.
 */
public class RefNetConverter extends NetConverterAbstract {

    /**
     * Constructor for the RefNetConverter
     *
     * @param converter which is being used for conversion
     * @param toolInsc  weither the tool inscription should be converted or not
     */
    public RefNetConverter(Converter converter, boolean toolInsc) {
        super(converter, toolInsc);
    }

    @Override
    public boolean isAttribute(String tagName) {
        return "type".equals(tagName) || "placeType".equals(tagName);
    }

    @Override
    public boolean isAnnotation(Element label) {
        String tagName = label.getNodeName();
        return super.isAnnotation(label) || tagName.equals("annotation") || tagName.equals("label")
            || tagName.equals("guard") || tagName.equals("uplink") || tagName.equals("downlink")
            || tagName.equals("action") || tagName.equals("create") || tagName.equals("expression");
    }

    @Override
    public boolean isInRenewAnnotation(Element label) {
        return label.getNodeName().equals("placeType");
    }

    @Override
    public TextFigure convertAnnotationToTextFigure(Element label) {
        String tagName = label.getNodeName();
        if (tagName.equals("guard") || tagName.equals("downlink") || tagName.equals("uplink")
            || tagName.equals("action") || tagName.equals("create") || tagName.equals("expression")
            || tagName.equals("placeType")) {
            return new CPNTextFigure(CPNTextFigure.INSCRIPTION);
        }

        return super.convertAnnotationToTextFigure(label);
    }

    /**
     * @param netType the netType which is being used for the comparison
     * @return weither the given netType is a RefNetType
     */
    public static boolean isNetParser(String netType) {
        return PNMLExportFormat.refNetType.equals(netType);
    }

    @Override
    public boolean createPageTag() {
        return false;
    }
}