package de.renew.gui.pnml.creator;

import org.w3c.dom.Element;


/**
 * Creates a tag with the name given in {@link #AttributeCreator(PNMLCreator, String)}.
 * Puts the text given in {@link #createElement(String)} into a {@code text} tag inside.
 * <p>
 * This class is very similar to {@link AnnotationCreator}, but takes the text directly
 * instead of taking a {@link CH.ifa.draw.figures.TextFigure}.
 */
public class AttributeCreator {
    private final PNMLCreator _pnmlCreator;
    private final Element _element;

    /**
     * Create and store a tag with the given tag name.
     */
    public AttributeCreator(PNMLCreator pnmlCreator, String tagName) {
        _element = pnmlCreator.createElement(tagName);
        _pnmlCreator = pnmlCreator;
    }

    /**
     * Put the given text into and return the tag set in {@link #AttributeCreator(PNMLCreator, String)}.
     */
    public Element createElement(String text) {
        Element textEle = _pnmlCreator.createTextElement(text);
        _element.appendChild(textEle);
        return _element;
    }
}