package de.renew.gui.pnml.creator;

import org.w3c.dom.Element;

import de.renew.gui.VirtualTransitionFigure;
import de.renew.gui.pnml.converter.Converter;


/**
 * Creates a virtual transition object for parsing nets into the pmnl format
 */
public class VirtualTransitionCreator extends NodeCreator {

    /**
     * Creates a VirtualTranisiton, by calling the constructor of
     * the NodeCreator and adding "VirtualTranisiton" as the tag.
     * @param converter the converter that will convert the tag to an object
     *                  for a CPNDrawing
     */
    public VirtualTransitionCreator(Converter converter) {
        super("VirtualTransition", converter);
    }

    @Override
    protected void doCreateObject(PNMLCreator pnmlCreator, Element element) {
        int parentId = ((VirtualTransitionFigure) getFigure()).getSemanticFigure().getID();
        element.setAttribute("semanticTransitionFigure", String.valueOf(parentId));
    }
}