package de.renew.gui.pnml.parser;

import java.awt.Color;
import java.awt.Point;

import org.w3c.dom.Element;

import de.renew.gui.pnml.converter.NetConverter;


/**
 * parse and create Nodes
 */
public abstract class NodeParser extends ObjectParser {
    public NodeParser(Element node, NetConverter converter) {
        super(node, converter);
    }

    private Point getLocation() {
        if (getGraphic().hasPosition()) {
            return getGraphic().positions().next();
        }

        return new Point();
    }

    @Override
    protected void initGraphic() {
        Color fillColor = getGraphic().getFill();
        Color lineColor = getGraphic().getLineColor();
        Point location = getLocation();
        Point topLeft = new Point(0, 0);
        Point bottomRight = getGraphic().getDimension();
        if (bottomRight == null) {
            bottomRight = new Point(20, 20);
        }

        if (fillColor != null) {
            figure().setAttribute("FillColor", fillColor);
        }
        if (lineColor != null) {
            figure().setAttribute("FrameColor", lineColor);
        }
        figure().displayBox(topLeft, bottomRight);
        moveObject(location.x - (bottomRight.x / 2), location.y - (bottomRight.y / 2));
    }
}