package de.renew.gui.pnml.parser;

import org.w3c.dom.Element;

import CH.ifa.draw.framework.FigureWithID;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.gui.TransitionFigure;
import de.renew.gui.VirtualTransitionFigure;
import de.renew.gui.pnml.converter.NetConverter;

/**
 * This class parses virtual transitions.
 */
public class VirtualTransitionParser extends NodeParser {
    private final Drawing _net;
    private int parentId;

    /**
     * Creates a new parser for virtual transitions.
     *
     * @param node The node to parse
     * @param net The net the node is in
     * @param converter The converter of the net
     */
    public VirtualTransitionParser(Element node, Drawing net, NetConverter converter) {
        super(node, converter);
        _net = net;
    }

    @Override
    public FigureWithID createObject() {
        FigureEnumeration figures = _net.figures();
        while (figures.hasMoreElements()) {
            Figure fig = figures.nextFigure();

            if (fig instanceof TransitionFigure transition) {

                if (transition.getID() == parentId) {
                    return new VirtualTransitionFigure(transition);
                }
            }
        }

        return new VirtualTransitionFigure();
    }

    @Override
    protected void parseFigure() {
        parentId = Integer.parseInt(getElement().getAttribute("semanticTransitionFigure"));
    }
}