package de.renew.gui.tool;

import java.awt.Point;
import javax.swing.JViewport;

import CH.ifa.draw.standard.StandardDrawingView;
import de.renew.draw.ui.ontology.DrawingEditor;
import de.renew.gui.GuiPlugin;


/**
 * Resets the zoom factor.
 */
public class ZoomResetTool extends AbstractZoomTool {

    public ZoomResetTool(DrawingEditor editor) {
        super(editor);
    }

    @Override
    public void activate() {
        super.activate();
        final GuiPlugin guiPlugin = GuiPlugin.getCurrent();
        if (guiPlugin != null && guiPlugin.getDrawingEditor() != null) {
            resetZoom();
        }
        editor().setStickyTools(false);
        editor().toolDone();
    }

    private void resetZoom() {
        StandardDrawingView standardDrawingView = getCurrentStandardDrawingView();
        if (standardDrawingView != null) {
            JViewport viewport = (JViewport) standardDrawingView.getParent();
            Point center = new Point(viewport.getWidth() / 2, viewport.getHeight() / 2);
            standardDrawingView.zoomOnPoint(1, center);
        }

    }
}