package de.renew.io.importFormats;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.gui.ShadowNetSystemRenderer;
import de.renew.io.FileFilterCreator;
import de.renew.ioontology.importing.ImportFormatAbstract;

/**
 * Implementation of ImportFormat for SNS files.
 */
public class SNSImportFormat extends ImportFormatAbstract<Drawing> {

    /**
     * Checks whether Sns imports are formatted correctly.
     */
    public SNSImportFormat() {
        super("ShadowNet System", FileFilterCreator.createSNSFileFilter());
    }


    @Override
    public List<Drawing> importFiles(URL[] files) throws Exception {
        if (files == null) {
            return Collections.emptyList();
        }

        List<Drawing> list = new ArrayList<>();
        for (URL file : files) {
            list.addAll(importFiles(file));
        }
        return list;
    }

    /**
     * Returns a list of all drawings in the file.
     * @param file the SNS file to be imported.
     * @return Enumeration, list of all imported drawings.
     * @throws Exception is thrown in case of failure during import of file.
     */
    protected List<Drawing> importFiles(URL file) throws Exception {
        if (file == null) {
            return Collections.emptyList();
        }

        return ShadowNetSystemRenderer.render(file);
    }
}