package de.renew.gui;

import java.util.stream.Stream;

import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

import CH.ifa.draw.figures.RectangleFigure;
import de.renew.draw.storables.ontology.Figure;

import static org.assertj.core.api.Assertions.assertThat;

class CPNTextFigureTest {

    @ParameterizedTest
    @MethodSource("figureProvider")
    void testIsInscription(Figure figure, boolean expected) {
        // when
        boolean actual = CPNTextFigure.isInscription(figure);

        // then
        assertThat(expected).isEqualTo(expected);
    }

    private static Stream<Arguments> figureProvider() {
        Figure otherFigure = new RectangleFigure();
        Figure labelFigure = new CPNTextFigure(CPNTextFigure.LABEL);
        Figure inscriptionFigure = new CPNTextFigure(CPNTextFigure.INSCRIPTION);
        Figure nameFigure = new CPNTextFigure(CPNTextFigure.NAME);
        Figure auxFigure = new CPNTextFigure(CPNTextFigure.AUX);
        Figure commFigure = new CPNTextFigure(CPNTextFigure.COMM);


        return Stream.of(
            org.junit.jupiter.params.provider.Arguments.of(otherFigure, false),
            org.junit.jupiter.params.provider.Arguments.of(labelFigure, false),
            org.junit.jupiter.params.provider.Arguments.of(inscriptionFigure, true),
            org.junit.jupiter.params.provider.Arguments.of(nameFigure, false),
            org.junit.jupiter.params.provider.Arguments.of(auxFigure, false),
            org.junit.jupiter.params.provider.Arguments.of(commFigure, false),
            org.junit.jupiter.params.provider.Arguments.of(null, false));
    }
}