package de.renew.imagenetdiff;

import java.io.File;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.ui.ontology.StatusDisplayer;

/**
 * Interface for {@code EPSDiffCommand} and {@code PNGDiffCommand} to implement {@code doDiff} method.
 * @author Lawrence Cabac
 */
public interface DiffExecutor {

    /**
     * Executes a diff of two drawings. Display result in separate frame.
     * @param sd - a status displayed to show the status to the user.
     * @param drawing1 - first drawing of the diff.
     * @param drawing2 - second drawing of the diff.
     * @param quite - create only the temporary files if true.
     *
     * @return returns a File object
     */
    File doDiff(StatusDisplayer sd, Drawing drawing1, Drawing drawing2, boolean quite);
}