package de.renew.imagenetdiff;


/**
 * Class for the command-line-based {@code ImageNetDiff} command in the {@code ImageNetDiff} plugin.
 * @author Lawrence Cabac
 *
 */
public class ImageNetDiffClCommand extends AbstractDiffClCommand {
    private static final String DIFF_COMMAND = "diff";

    /**
     * Constructor of ImageNetDiffClCommand. Initializes the fields of the superclass.
     */
    public ImageNetDiffClCommand() {
        super();
        _diffCommand = new PNGDiffCommand();
        _command = DIFF_COMMAND;
    }

    /* (non-Javadoc)
     * @see de.renew.plugin.command.CLCommand#getDescription()
     */
    @Override
    public String getDescription() {
        return "Synopsis: " + getName() + " file1 [file2]. Constructs a diff image.\n"
            + "                if only one argument is given " + getName()
            + " assumes diff against \n"
            + "                svn base file (in <filepath>/.svn/text-base/<filename>.svn-base).\n"
            + "                Command produces PNG files of drawings in temp folder.";

    }
}