package de.renew.logging;


/**
 * Represents color constants.
 * @author Konstantin Simon Maria Moellers
 * @version 2015-10-14
 */
public enum CliColor {

    /**
     * Background color black as a constant.
     */
    BACKGROUND_BLACK("40"),

    /**
     * Background color blue as a constant.
     */
    BACKGROUND_BLUE("44"),

    /**
     * Background color cyan as a constant.
     */
    BACKGROUND_CYAN("46"),

    /**
     * Background color green as a constant.
     */
    BACKGROUND_GREEN("42"),

    /**
     * Background color light-gray as a constant.
     */
    BACKGROUND_LIGHT_GRAY("47"),

    /**
     * Background color magenta as a constant.
     */
    BACKGROUND_MAGENTA("45"),

    /**
     * Background color red as a constant.
     */
    BACKGROUND_RED("41"),

    /**
     * Background color yellow as a constant.
     */
    BACKGROUND_YELLOW("43"),

    /**
     * Color constant black.
     */
    BLACK("30"),

    /**
     * Color constant blue.
     */
    BLUE("34"),

    /**
     * Font constant bold.
     */
    BOLD("1"),

    /**
     * Font constant crossed out.
     */
    CROSSED_OUT("9"),

    /**
     * Font constant italic.
     */
    ITALIC("3"),

    /**
     * Font constant normal.
     */
    NORMAL("0"),

    /**
     * Font constant underline.
     */
    UNDERLINE("4"),

    /**
     * Color constant cyan.
     */
    CYAN("36"),

    /**
     * Color constant green.
     */
    GREEN("32"),

    /**
     * Color constant purple.
     */
    PURPLE("35"),

    /**
     * Color constant red.
     */
    RED("31"),

    /**
     * Color constant white.
     */
    WHITE("37"),

    /**
     * Color constant yellow.
     */
    YELLOW("33");

    private final String _config;

    /**
     * Creases a Color object for the color specified via ANSI escape code.
     *
     * https://en.wikipedia.org/wiki/ANSI_escape_code
     *
     * @param config The ANSI escape code number for the color.
     */
    CliColor(String config) {
        this._config = config;
    }

    /**
     * Colors a string with given options.
     *
     * @param str - The string to be colored.
     * @param formats - The colors to be applied to the string.
     * @return The String str wrapped in the ANSI color format escaped sequences for the colors provided.
     */
    public static String color(String str, CliColor... formats) {
        StringBuilder join = new StringBuilder();
        for (CliColor format : formats) {
            if (join.length() != 0) {
                join.append(';');
            }
            join.append(format.toString());
        }

        return "\u001b[" + join + "m" + str + "\u001b[m";
    }

    /**
     * Color the given String str by wrapping it in the ANSI escape sequence for this color.
     * @param str The string to be colored.
     * @return The string wrapped inside the ANSI escape sequence.
     */
    public String color(String str) {
        return color(str, this);
    }

    public String toString() {
        return _config;
    }
}