package de.renew.plugin;

import de.renew.plugin.command.CLCommand;


/**
 * Enables addition and removal of CLCommands to a CommandsListener
 */
public interface CommandsListener {
    /**
     * Adds a command to listen for to a CommandsListener
     * @param name Name of the Command to be listened for
     * @param command The command to be listened for
     */
    public void commandAdded(String name, CLCommand command);

    /**
     * Removes a command from the CommandListener
     * @param name The name of the command to be removed from the CommandListener
     */
    public void commandRemoved(String name);
}