package de.renew.plugin.di;


/**
 * Service Definition
 * @param <T> the type of the provided class
 * @author Konstantin Simon Maria Moellers
 * @version 2015-10-11
 */
public interface Definition<T> {

    /**
     * Creates a service instance.
     *
     * @return The new instance.
     */
    T create();

    /**
     * Returns service of this definition
     * @return The service being defined.
     */
    Class<?> getService();
}