package de.renew.plugin.di;

import java.util.concurrent.Callable;


/**
 * Definition of factory method
 * @author Konstantin Simon Maria Moellers
 * @version 2015-10-11
 * @param <T> Definition given to factory
 */
final public class FactoryDefinition<T> extends AbstractDefinition<T> {
    private Callable<T> _factory;

    /**
     * Constructor of factory method
     * @param service Service given for this definition
     * @param factory Factory to be called
     */
    public FactoryDefinition(Class<?> service, Callable<T> factory) {
        super(service);
        setFactory(factory);
    }

    @Override
    public T create() {
        try {
            return _factory.call();
        } catch (Exception e) {
            return null;
        }
    }

    /**
     * Returns factory of the factory definition
     * @return Returns factory taken from this definition
     */
    public Callable<T> getFactory() {
        return _factory;
    }

    /**
     * Adds a given factory to the definition
     * @param factory Factory to be added to this definition
     */
    public void setFactory(Callable<T> factory) {
        this._factory = factory;
    }
}