package de.renew.plugin.jpms;

import java.util.Set;


/**
 * Callback interface for events related to the module layer management.  Given
 * its  nature,  subclasses  will want to be registered  before  startup  time.
 * Furthermore,  it's  not  permitted  to keep  strong  references  on  layers,
 * modules,  or classes therein, or to prevent garbage collection of  these  in
 * any  other  way  or  form,  after  the  callback  {@link #layerRemoved}  has
 * returned for a specific module layer.
 *
 * @author Kjell Ehlers
 * @since Renew 4.2
 */
public interface ModuleLayerListener {

    /**
     * Invoked when a newly created module layer is added to the runtime.
     *
     * @param modules the modules of the added layer. Mayn't be {@code null}.
     */
    void layerAdded(Set<Module> modules);

    /**
     * Invoked  when  a  previously loaded module layer  is  removed  from  the
     * runtime.  The callee must ensure that after this method  returns,  there
     * aren't  any strong references to the modules, contained classes  or  the
     * layer itself that remain in the system.
     *
     * @param modules the modules of the removed layer. Mayn't be {@code null}.
     */
    void layerRemoved(Set<Module> modules);
}
