package de.renew.plugin.jpms.impl;

import java.util.List;
import java.util.Objects;

import de.renew.plugin.jpms.ComponentLayer;


/**
 * The layer of a single plugin.
 *
 * @param name the name of this {@code ComponentLayer}.
 * @param control the controller that governs this component's module layer.
 * @param parents this component's parents.
 *
 * @author Kjell Ehlers
 * @since Renew 4.2
 */
record PluginLayer(String name, ModuleLayer.Controller control,
    List<ComponentLayer> parents) implements ComponentLayer {
    public PluginLayer {
        Objects.requireNonNull(name);
        Objects.requireNonNull(control);

        // defensive copy and implicit null-check of parents
        parents = List.copyOf(parents);
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public ModuleLayer.Controller getController() {
        return control;
    }

    @Override
    public List<ComponentLayer> parents() {
        return parents;
    }
}
