package de.renew.plugin.load;


/**
 * This exception is thrown by the SimplePluginLoader and its subclass when
 * a plugin fails to initialize
 * @author Konstantin Simon Maria Moellers
 * @version 2015-10-10
 */
public class PluginInstantiationException extends Exception {
    /**
     * Constructor for PluginInstantiationException.
     * Creates the exception when a plugin fails to initialize and returns a buildMessage
     * that includes the failing plugins name and the cause for failure.
     * @param pluginName Name-string of the Plugin that failed to initialize
     * @param cause ReflectiveOperationException that was caught at initialization failure.
     */
    public PluginInstantiationException(String pluginName, Throwable cause) {
        super(buildMessage(pluginName, cause), cause);
    }

    private static String buildMessage(String pluginName, Throwable cause) {
        return String.format("Could not instantiate %s, caused by %s.", pluginName, cause);
    }
}