package de.renew.plugin.command;

import java.net.URL;

import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;

import static de.renew.plugin.LoadHelper.getJar;
import static de.renew.plugin.LoadHelper.isPluginLoaded;
import static de.renew.plugin.PluginProperties.NAME;
import static de.renew.plugin.PluginProperties.VERSION;
import static de.renew.plugin.command.CommandHelper.doExecuteSuccessfully;
import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertTrue;

public class InfoCommandTest {

    @BeforeAll
    public static void before() {
        if (isPluginLoaded("TestPlugin InfoCommand")) {
            return;
        }
        final URL jar = getJar(InfoCommand.class, "InfoCommand-main.jar");
        PluginManager.getInstance().loadPlugin(jar);
        assertTrue(isPluginLoaded("TestPlugin InfoCommand"));
    }

    @Test
    public void testExecuteHappyPath() {
        final String result = doExecuteSuccessfully(new InfoCommand(), "TestPlugin InfoCommand");
        assertTrue(result.contains("Properties of plugin TestPlugin InfoCommand"));
        assertTrue(result.contains("no main class"));
        assertTrue(result.contains("0.1")); // this is the set version
    }

    @Test
    public void testRenderProperties() {
        PluginProperties pluginProperties = new PluginProperties(null);
        pluginProperties.setKnownProperties();
        pluginProperties.setProperty(NAME, "myName");
        pluginProperties.setProperty(VERSION, "1.1.1");

        final String rendered = InfoCommand.renderProperties(pluginProperties);
        assertEquals("myName", pluginProperties.getName());
        assertEquals("1.1.1", pluginProperties.getVersion());
        assertTrue(rendered.contains("myName"));
        assertTrue(rendered.contains("1.1.1"));
    }

}
