package de.renew.logging.gui;

import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;


/**
 * Provides a dialog for the user to add a new Logger.
 * This dialog is accessed via
 * {@code Simulation -> Configure Simulation -> Logging -> context menu of a logger}
 *
 * @author Sven Offermann
 **/
public class NewLoggerDialog extends JDialog {

    /**
     * The commit-status of the dialog
     */
    private boolean _commit = false;

    /**
     * A label for the logger name
     */
    private JLabel _loggerLabel;

    /**
     * The ok button
     */
    private JButton _okButton;

    /**
     * A text field for the dialog
     */
    private JTextField _loggerField;

    /**
     * The button to cancel the dialog
     */
    private JButton _cancelButton;

    /**
     * Creates new Logger Dialog.
     * @param parent The parent {@code Dialog}
     */
    public NewLoggerDialog(Dialog parent) {
        super(parent, "new logger", true);
        initComponents();
        pack();
    }

    /**
     * This method is called from within the constructor to
     * initialize the form.
     **/
    private void initComponents() {
        GridBagConstraints gridBagConstraints;

        _loggerLabel = new JLabel();
        _loggerField = new JTextField();
        _okButton = new JButton();
        _cancelButton = new JButton();

        getContentPane().setLayout(new GridBagLayout());

        addWindowListener(new WindowAdapter() {
            @Override
            public void windowClosing(WindowEvent evt) {
                cancelDialog();
            }
        });

        _loggerLabel.setText("Logger name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = GridBagConstraints.HORIZONTAL;
        getContentPane().add(_loggerLabel, gridBagConstraints);

        _loggerField.setText("netname.elementname");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = GridBagConstraints.HORIZONTAL;
        getContentPane().add(_loggerField, gridBagConstraints);

        _okButton.setText("OK");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 0.5;
        _okButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                commitDialog();
            }
        });
        getContentPane().add(_okButton, gridBagConstraints);

        _cancelButton.setText("Cancel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 0.5;
        _cancelButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                cancelDialog();
            }
        });
        getContentPane().add(_cancelButton, gridBagConstraints);
    }

    private void commitDialog() {
        _commit = true;
        setVisible(false);
        dispose();
    }

    private void cancelDialog() {
        _commit = false;
        setVisible(false);
        dispose();
    }

    /**
     * Boolean return depending on the committed-status of the dialog
     * @return false if the Dialog has not been committed yet,
     * true if it has
     */
    public boolean isCommitted() {
        return _commit;
    }

    /**
     * Getter for the text in the loggerField
     * @return the text from the loggerField
     */
    public String getLogger() {
        return _loggerField.getText();
    }

    /**
     * Setter for the loggerField text for a given logger
     * @param logger the logger where the text should be changed
     */
    public void setLogger(String logger) {
        _loggerField.setText(logger);
    }
}