package de.renew.logging.gui.test.helper;

import java.util.LinkedList;
import java.util.List;

import de.renew.logging.gui.RepositoryChangeListener;
import de.renew.logging.gui.StepTrace;
import de.renew.logging.gui.StepTraceRemoveRequest;
import de.renew.logging.gui.StepTraceRepository;

public class TestRepositoryChangeListener implements RepositoryChangeListener {

    final List<StepTraceRepository> _stepTraceRepositoryAddedList = new LinkedList<>();
    final List<StepTraceRepository> _stepTraceRepositoryRemovedList = new LinkedList<>();
    final List<StepTrace> _stepTraceAddedList = new LinkedList<>();
    private final List<StepTrace> _stepTraceChangedList = new LinkedList<>();
    private final List<StepTrace> _stepTraceRemovedList = new LinkedList<>();

    public List<StepTraceRepository> getStepTraceRepositoryRemovedList() {
        return _stepTraceRepositoryRemovedList;
    }

    public List<StepTrace> getStepTraceRemovedList() {
        return _stepTraceRemovedList;
    }


    public List<StepTrace> getStepTraceChangedList() {
        return _stepTraceChangedList;
    }


    public List<StepTraceRepository> getStepTraceRepositoryAddedList() {
        return _stepTraceRepositoryAddedList;
    }

    public List<StepTrace> getStepTraceAddedList() {
        return _stepTraceAddedList;
    }


    @Override
    public void stepTraceAdded(final StepTraceRepository repository, final StepTrace stepTrace) {
        _stepTraceRepositoryAddedList.add(repository);
        _stepTraceAddedList.add(stepTrace);
    }

    @Override
    public void stepTraceRemoved(final StepTraceRepository repository, final StepTrace stepTrace) {
        this._stepTraceRepositoryRemovedList.add(repository);
        this._stepTraceRemovedList.add(stepTrace);
    }

    @Override
    public void stepTraceRemoveRequest(final StepTraceRemoveRequest request) {
        throw new UnsupportedOperationException(
            "Method is not defined: TestRepositoryChangeListener#stepTraceRemoveRequest");
    }

    @Override
    public void stepTraceChanged(final StepTrace stepTrace) {
        this._stepTraceChangedList.add(stepTrace);
    }
}
